# README: CA1 dopamine model

This is the README for the CA1 dopamine model for the submitted paper:

**In silico investigation of the puzzling dopamine effects on excitability and synaptic plasticity in hippocampal CA1 pyramidal neurons**

Enrico Manara, Andrea Mele & Michele Migliore

## Abstract
It has been shown that in the CA1 region of the hippocampus, dopamine modulates memory functions by influencing spike-timing-dependent plasticity (STDP) and intrinsic neuronal properties. Although experimental findings have suggested potential mechanisms, their detailed interplay remains incompletely understood. Here, using a realistic CA1 pyramidal neuron model, we have investigated the possible effects of dopaminergic modulation on a neuron’s signal integration and synaptic plasticity processes. The results suggest a physiological plausible explanation for the puzzling experimental observation that long-term potentiation (LTP) increases in spite of a reduction in the neuron’s excitability, and explains why physiological dopamine levels are necessary for LTP induction. The model suggests experimentally testable predictions on which ion channel kinetic properties can modulate the interplay between synaptic plasticity and neuronal excitability, thereby identifying potential molecular targets for therapeutic intervention.

---
### Usage Instructions

Implemented in NEURON 8.2.0, using HOC language

**1.**  Download and extract the archive.

**2.**  To compile the mod files, use the mknrndll command.

**3.** Double click on the simulation file *Low_DOPAMINE(fig.2).hoc* to open the simulation window for reproducing results of fig.2 under Low DA, double click on *Control_DOPAMINE (fig.2).hoc* will reproduce results under Control condition.
<br>
<br>
<br>

**Attention:**
- The model works best with the variable time step
- Not tested on NEURON for Linux/Unix or macOS

Questions on how to use this model should be directed to michele.migliore@cnr.it or enrico.manara@ibf.cnr.it





